<?php
/*======================================================================*\
|| #################################################################### ||
|| # vBulletin 3.7.0 Release Candidate 3
|| # ---------------------------------------------------------------- # ||
|| # Copyright 2000-2008 Jelsoft Enterprises Ltd. All Rights Reserved. ||
|| # This file may not be redistributed in whole or significant part. # ||
|| # ---------------- VBULLETIN IS NOT FREE SOFTWARE ---------------- # ||
|| # http://www.vbulletin.com | http://www.vbulletin.com/license.html # ||
|| #################################################################### ||
\*======================================================================*/

error_reporting(E_ALL & ~E_NOTICE);

define('THIS_SCRIPT', 'upgrade_370rc3.php');
define('VERSION', '3.7.0 Release Candidate 3');
define('PREV_VERSION', '3.7.0 Release Candidate 2');

$phrasegroups = array();
$specialtemplates = array();

// #############################################################################
// require the code that makes it all work...
require_once('./upgradecore.php');

// #############################################################################
// welcome step
if ($vbulletin->GPC['step'] == 'welcome')
{
	if ($vbulletin->options['templateversion'] == PREV_VERSION)
	{
		echo "<blockquote><p>&nbsp;</p>";
		echo "$vbphrase[upgrade_start_message]";
		echo "<p>&nbsp;</p></blockquote>";
	}
	else
	{
		echo "<blockquote><p>&nbsp;</p>";
		echo "$vbphrase[upgrade_wrong_version]";
		echo "<p>&nbsp;</p></blockquote>";
		print_upgrade_footer();
	}
}

// #############################################################################
// FINAL step (notice the SCRIPTCOMPLETE define)
if ($vbulletin->GPC['step'] == 1)
{
	require_once(DIR . '/includes/class_bitfield_builder.php');
	vB_Bitfield_Builder::save($db);

	if (!isset($vbulletin->bf_ugp_adminpermissions['canadminnotices']))
	{
		echo "<blockquote><p>&nbsp;</p>";
		echo "$upgradecore_phrases[wrong_bitfield_xml]";
		echo "<p>&nbsp;</p></blockquote>";
		print_upgrade_footer();
	}

	// add the hidden variable to customized versions of thes templates, so they don't suddenly fail
	require_once(DIR . '/includes/adminfunctions_template.php');

	$templates = $db->query_read("
		SELECT *
		FROM " . TABLE_PREFIX . "template
		WHERE styleid > 0
			AND title IN ('modifyprofile', 'announcement_edit')
	");
	while ($template = $db->fetch_array($templates))
	{
		if (strpos($template['template_un'], '$bbuserinfo[logouthash]') !== false)
		{
			continue;
		}

		switch ($template['title'])
		{
			case 'announcement_edit':
				$template['template_un'] = str_replace(
					'<input type="hidden" name="do" value="update" />',
					'<input type="hidden" name="do" value="update" />' . "\n" . '<input type="hidden" name="verifyhash" value="$bbuserinfo[logouthash]" />',
					$template['template_un']
				);
				break;

			case 'modifyprofile':
				$template['template_un'] = str_replace(
					'<input type="hidden" name="do" value="updateprofile" />',
					'<input type="hidden" name="do" value="updateprofile" />' . "\n" . '<input type="hidden" name="verifyhash" value="$bbuserinfo[logouthash]" />',
					$template['template_un']
				);
				break;
		}

		$compiled_template = compile_template($template['template_un']);

		$db->query_write("
			UPDATE " . TABLE_PREFIX . "template SET
				template = '" . $db->escape_string($compiled_template) . "',
				template_un = '" . $db->escape_string($template['template_un']) . "'
			WHERE templateid = $template[templateid]
		");
	}

	// give all admins notices permissions by default
	$db->query_write("
		UPDATE " . TABLE_PREFIX . "administrator SET
			adminpermissions = adminpermissions | " .
				($vbulletin->bf_ugp_adminpermissions['canadminnotices'] + $vbulletin->bf_ugp_adminpermissions['canadminmodlog'])
	);

	require_once(DIR . '/includes/functions_databuild.php');
	build_birthdays();

	// tell log_upgrade_step() that the script is done
	define('SCRIPTCOMPLETE', true);
}

// #############################################################################

print_next_step();
print_upgrade_footer();

/*======================================================================*\
|| ####################################################################
|| # CVS: $RCSfile$ - $Revision: 13568 $
|| ####################################################################
\*======================================================================*/
?>